#!/usr/bin/perl -w
use strict;


####Gene information of mitochondria.
my $region_file = "example_mito.bed";
open F, $region_file || "$!";
my %gene2pos;
while (<F>) {
    chomp;
    my @line = split/\t/,$_;
    $gene2pos{$line[0]}->{"Start"} = $line[1];
    $gene2pos{$line[0]}->{"End"} = $line[2];
}

####Total mapped reads to human genome using tophat.
my $total_file = "example_tophat_mapInfo.txt";
open TF, $total_file || "$!";
<TF>;
my %sample2read;
while (<TF>) {
    chomp;
    my @line = split/\t/,$_;
    $sample2read{$line[0]} = $line[1];
    print join("\t",$line[0],$line[1]),"\n";
}


####Mapping result of bowtie by mapping reads to mitochondria genome using bowtie.
my $path = "./bowtie/";
chdir $path;

my @fs = glob("*.sam");
my %sample2chrm;
foreach my $f (@fs) {
    
    print "ReadFile:\t$f\n";
    my ($sp) = split/.sam/,$f;
    print "Sample:\t$sp\n";
    
    open SAM, $f || "$!";
    my %gene2read;
    my $mappedtogene = 0;
    
    FLAG: while (<SAM>) {
        if ($_ =~ /^@/) {
            next FLAG;
        }
        chomp;
        my @line = split/\t/,$_;
        my $start = $line[3];
        my ($length) = split/M/,$line[5];
        my $end = $start + $length -1;
        
        foreach my $k (keys %gene2pos) {
            my $gstart = $gene2pos{$k}->{"Start"};
            my $gend = $gene2pos{$k}->{"End"};
            #within genebody
            #if (($start >= $gstart) && ($end <= $gend)) {
            #    $gene2read{$k}++;
            #    $mappedtogene++;
            #}
            #
            #overlap genebody
            if (($start > $gend) || ($end < $gstart)) {
                1;#no overlap
            }
            else {
                $gene2read{$k}++;
                $mappedtogene++;
            }            
        }
    }
    
    my $target = "$path/abundance";
    if (!(-e $target)) {
        system("mkdir $target");
    }
    open OUT, ">$target/${sp}_includeRNR_rpkm.txt" || "$!";
    foreach my $k (sort keys %gene2read) {
        my $len = $gene2pos{$k}->{"End"} - $gene2pos{$k}->{"Start"} + 1;
        my $exp = ($gene2read{$k}*(10**9))/($sample2read{$sp}*$len);
        print OUT join("\t",$k,$gene2read{$k},$exp),"\n";
    }
    
    my $relative = $mappedtogene/$sample2read{$sp};
    $sample2chrm{$sp} = $relative
}

open RELATIVE, ">$path/abundance/includeRNR-RelativeExpression.txt" || "$!";
foreach my $k (sort keys %sample2chrm) {
    print RELATIVE join("\t",$k,$sample2chrm{$k}),"\n";
}

print "All finished:$!";
